package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplates;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.common.utils.ModelWithBlockPageIdsUtils;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesMultistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;

@Component
public class BlockWithDesignTemplatesAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithDesignTemplates> {
    @Override
    public Class<BlockWithDesignTemplates> getTypeClass() {
        return BlockWithDesignTemplates.class;
    }

    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<BlockWithDesignTemplates> models) {
        models.forEach(it -> {
            if (it.getDesignTemplates() == null) {
                return;
            }

            it.setDesignTemplates(it.getDesignTemplates().stream()
                    .filter(dt -> !dt.getMultistate().hasFlag(DesignTemplatesStateFlag.DELETED))
                    .peek(dt -> dt.setId(null))
                    .peek(dt -> dt.setMultistate(new DesignTemplatesMultistate()))
                    .collect(Collectors.toList())
            );
            ModelWithBlockPageIdsUtils.clearPageBlockIds(it.getDesignTemplates());
        });
    }

    @Override
    public void beforeExecution(BlockContainer addContainer, List<BlockWithDesignTemplates> models) {
        models.forEach(it -> ModelWithBlockPageIdsUtils.setPageBlockIds(it.getDesignTemplates(),
                it, addContainer.getMode()));
    }
}
