package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplatesAndDependsFields;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.core.entity.block.type.designtemplates.designsettings.DesignSettingsAdjustService;
import ru.yandex.partner.core.entity.common.utils.ModelWithBlockPageIdsUtils;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;

@Component
public class BlockWithDesignTemplatesAndDependsFieldsAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithDesignTemplatesAndDependsFields> {
    private final DesignSettingsAdjustService designSettingsAdjustService;

    public BlockWithDesignTemplatesAndDependsFieldsAddOperationTypeSupport(
            DesignSettingsAdjustService designSettingsAdjustService) {
        this.designSettingsAdjustService = designSettingsAdjustService;
    }

    @Override
    public Class<BlockWithDesignTemplatesAndDependsFields> getTypeClass() {
        return BlockWithDesignTemplatesAndDependsFields.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithDesignTemplatesAndDependsFields> models) {
        for (BlockWithDesignTemplatesAndDependsFields model : models) {
            if (model.getSiteVersion() == null) {
                // todo тут нужна вилка для разных моделей
                //  https://github.yandex-team.ru/partner/partner2/blob/
                //  f84db2f2665349cc20f459d6cf27c87d87213216/lib/Application/Model/Role/Has/SiteVersion
                //  .pm#L179-L183
                model.setSiteVersion(SiteVersionType.DESKTOP.getLiteral());
            }

            if (model.getDesignTemplates() != null) {
                for (DesignTemplates designTemplate : model.getDesignTemplates()) {
                    if (designTemplate.getType() == null) {
                        designTemplate.setType(CoreConstants.DEFAULT_DESIGN_TEMPLATES_TYPE);
                    }

                    designSettingsAdjustService.adjustTemplateSettings(
                            models,
                            BlockWithDesignTemplatesAndDependsFields::getDesignTemplates,
                            BlockWithDesignTemplatesAndDependsFields::getSiteVersion
                    );
                }
            }
        }
    }

    @Override
    public void beforeExecution(BlockContainer addContainer, List<BlockWithDesignTemplatesAndDependsFields> models) {
        models.forEach(it -> ModelWithBlockPageIdsUtils.setPageBlockIds(it.getDesignTemplates(),
                it, addContainer.getMode()));
    }
}
