package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplates;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplatesAndDependsFields;
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersion;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.block.type.designtemplates.designsettings.DesignSettingsAdjustService;

@Order(200)
@Component
public class BlockWithDesignTemplatesAndDependsFieldsUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithDesignTemplatesAndDependsFields> {

    private final DesignSettingsAdjustService designSettingsAdjustService;


    public BlockWithDesignTemplatesAndDependsFieldsUpdateOperationTypeSupport(
            DesignSettingsAdjustService designSettingsAdjustService,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade
    ) {
        super(blockRepositoryTypeSupportFacade);
        this.designSettingsAdjustService = designSettingsAdjustService;
    }

    @Override
    public Class<BlockWithDesignTemplatesAndDependsFields> getTypeClass() {
        return BlockWithDesignTemplatesAndDependsFields.class;
    }

    @Override
    public void onChangesApplied(
            BlockContainer updateContainer,
            List<AppliedChanges<BlockWithDesignTemplatesAndDependsFields>> appliedChanges) {

        designSettingsAdjustService.adjustTemplateSettings(appliedChanges,
                changes -> {
                    if (!changes.changed(BlockWithDesignTemplates.DESIGN_TEMPLATES)) {
                        return null;
                    } else {
                        return changes.getNewValue(BlockWithDesignTemplates.DESIGN_TEMPLATES);
                    }
                },

                changes -> {
                    var blockWithSiteVersion = (BlockWithSiteVersion) changes.getModel();
                    return blockWithSiteVersion.getSiteVersion();
                }
        );
    }


}
