package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import NPartner.Page.TPartnerPage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import one.util.streamex.StreamEx;

import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;

public final class BlockWithDesignTemplatesBkDataHelper {
    private static final Set<String> WIDE_FORMATS = Set.of(
            "240x400",
            "320x480",
            "300x600",
            "300x500",
            "200x300",
            "728x90",
            "320x50",
            "320x100",
            "970x250",
            "horizontal",
            "posterVertical",
            "posterHorizontal",
            "extensibleMobile",
            "newVk"
    );
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private BlockWithDesignTemplatesBkDataHelper() {
        // utility class
    }

    public static void fillAllowedImageTypes(
            TPartnerPage.TBlock.Builder bkData,
            List<DesignTemplates> designTemplates
    ) {
        String directFormat;
        directFormat = designTemplates.stream()
                .min(Comparator.comparing(dt -> String.valueOf(dt.getId())))
                .map(DesignTemplates::getDesignSettings)
                .map(settings -> (String) settings.get("name"))
                .orElse("");

        fillAllowedImageTypesByDirectFormat(bkData, directFormat);
    }

    public static void fillAllowedImageTypes(
            TPartnerPage.TBlock.Builder bkData
    ) {
        if (bkData.getAllowedImageTypeCount() > 0) {
            return;
        }

        if (!bkData.hasRtbDesign()) {
            return;
        }

        try {
            var rtbDesigns = OBJECT_MAPPER.readTree(bkData.getRtbDesign());
            String directFormat;
            if (rtbDesigns.isObject()) {
                directFormat = StreamEx.of(rtbDesigns.fields())
                        .min(Map.Entry.comparingByKey(Comparator.naturalOrder()))
                        .map(Map.Entry::getValue)
                        .map(design -> design.path("design").path("name").asText(""))
                        .orElse("");
            } else if (rtbDesigns.isTextual()) {
                var oneDesign = OBJECT_MAPPER.readTree("{" + rtbDesigns.asText() + "}");
                directFormat = oneDesign.path("name").asText("");
            } else {
                directFormat = "";
            }
            fillAllowedImageTypesByDirectFormat(bkData, directFormat);
        } catch (JsonProcessingException ex) {
            throw new RuntimeException("Design is not parseable!");
        }
    }

    private static void fillAllowedImageTypesByDirectFormat(TPartnerPage.TBlock.Builder bkData,
                                                            String directFormat) {
        bkData.addAllAllowedImageType(List.of("small", "regular"));
        if (WIDE_FORMATS.contains(directFormat)) {
            bkData.addAllowedImageType("wide");
        }
    }
}
