package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplates;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService;
import ru.yandex.partner.core.entity.designtemplates.actions.all.factories.DesignTemplatesActionAddFactory;
import ru.yandex.partner.core.entity.designtemplates.actions.all.factories.DesignTemplatesDeleteFactory;
import ru.yandex.partner.core.entity.designtemplates.actions.all.factories.DesignTemplatesEditFactory;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.service.add.DesignTemplatesAddOperationFactory;
import ru.yandex.partner.core.multitype.repository.relation.CollectionRelation;
import ru.yandex.partner.core.multitype.repository.relation.Relation;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

import static ru.yandex.partner.core.entity.block.model.prop.RtbBlockDesignTemplatesPropHolder.DESIGN_TEMPLATES;

@Component
public class BlockWithDesignTemplatesUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithDesignTemplates> {
    private static final Set<ModelProperty<? super BlockWithDesignTemplates, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(DESIGN_TEMPLATES);
    private final Relation<BlockWithDesignTemplates, DesignTemplates, List<DesignTemplates>> designTemplatesRelation;
    private final BlockWithDesignTemplatesRepositoryTypeSupport blockWithDesignTemplatesRepositoryTypeSupport;

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public BlockWithDesignTemplatesUpdateOperationTypeSupport(
            ActionPerformer actionPerformer,
            DesignTemplatesDeleteFactory designTemplatesDeleteFactory,
            DesignTemplatesEditFactory designTemplatesEditFactory,
            DesignTemplatesActionAddFactory designTemplatesActionAddFactory,
            DesignTemplatesAddOperationFactory designTemplatesAddOperationFactory,
            BlockWithDesignTemplatesRepositoryTypeSupport blockWithDesignTemplatesRepositoryTypeSupport,
            EditableFieldsService<BaseDesignTemplates> editableFieldsService,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade) {
        super(blockRepositoryTypeSupportFacade);
        this.blockWithDesignTemplatesRepositoryTypeSupport = blockWithDesignTemplatesRepositoryTypeSupport;
        this.designTemplatesRelation = new CollectionRelation<>(
                DESIGN_TEMPLATES,
                null,
                new DesignTemplatesUpdateStrategy(actionPerformer,
                        designTemplatesDeleteFactory,
                        designTemplatesEditFactory,
                        designTemplatesActionAddFactory,
                        designTemplatesAddOperationFactory,
                        editableFieldsService),
                DesignTemplates::getId
        );
    }

    @Override
    public void onChangesApplied(BlockContainer updateContainer,
                                 List<AppliedChanges<BlockWithDesignTemplates>> appliedChanges) {
        for (var changes : appliedChanges) {
            var designTemplates = changes.getNewValue(DESIGN_TEMPLATES);
            if (designTemplates == null) {
                continue;
            }

            for (DesignTemplates designTemplate : designTemplates) {
                if (designTemplate.getType() == null) {
                    designTemplate.setType(DesignTemplatesType.tga);
                }
            }
        }
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext, BlockContainer updateContainer,
                                                   List<AppliedChanges<BlockWithDesignTemplates>> appliedChanges) {
        designTemplatesRelation.processUpdate(
                appliedChanges.stream()
                        .filter(changes -> changes.changed(designTemplatesRelation.getProperty()))
                        .map(changes -> {
                            var newValue = changes.getNewValue(designTemplatesRelation.getProperty());
                            newValue.forEach(template -> {
                                template.setBlockId(changes.getModel().getBlockId());
                                template.setPageId(changes.getModel().getPageId());
                            });
                            return Pair.of(
                                    changes.getOldValue(designTemplatesRelation.getProperty()),
                                    newValue
                            );
                        })
                        .collect(Collectors.toList()),
                updateContainer.getIncomingFields()
        );
        blockWithDesignTemplatesRepositoryTypeSupport.enrichModelFromOtherTables(
                dslContext,
                Lists.transform(appliedChanges, AppliedChanges::getModel)
        );
    }

    @Override
    public Set<ModelProperty<? super BlockWithDesignTemplates, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }

    @Override
    public Class<BlockWithDesignTemplates> getTypeClass() {
        return BlockWithDesignTemplates.class;
    }
}
