package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

@ParametersAreNonnullByDefault
public class DesignTemplatesContainer implements UpdateOperationContainer<DesignTemplates>, RepositoryContainer {
    private String siteVersion;
    private boolean validateAsManager;
    private Set<DesignTemplatesType> availableDesignTypes;
    private Map<Long, DesignTemplates> unmodifiedTemplates;
    private OperationMode mode;

    public Set<DesignTemplatesType> getAvailableDesignTypes() {
        return availableDesignTypes;
    }

    public void setAvailableDesignTypes(Set<DesignTemplatesType> availableDesignTypes) {
        this.availableDesignTypes = availableDesignTypes;
    }

    public String getSiteVersion() {
        return siteVersion;
    }

    public void setSiteVersion(String siteVersion) {
        this.siteVersion = siteVersion;
    }

    public boolean canValidateAsManager() {
        return validateAsManager;
    }

    public void setValidateAsManager(boolean validateAsManager) {
        this.validateAsManager = validateAsManager;
    }

    public Map<Long, DesignTemplates> getUnmodifiedTemplates() {
        return unmodifiedTemplates;
    }

    public void setUnmodifiedTemplates(Map<Long, DesignTemplates> unmodifiedTemplates) {
        this.unmodifiedTemplates = unmodifiedTemplates;
    }

    public DesignTemplatesContainer withSiteVersion(String siteVersion) {
        this.siteVersion = siteVersion;
        return this;
    }

    public DesignTemplatesContainer withAvailableDesignTypes(Set<DesignTemplatesType> types) {
        this.availableDesignTypes = types;
        return this;
    }

    public DesignTemplatesContainer withValidateAsManager(boolean validateAsManager) {
        this.validateAsManager = validateAsManager;
        return this;
    }

    public DesignTemplatesContainer withUnmodifiedTemplates(Map<Long, DesignTemplates> unmodifiedTemplates) {
        this.unmodifiedTemplates = unmodifiedTemplates;
        return this;
    }

    public OperationMode getMode() {
        return mode;
    }

    public void setMode(OperationMode mode) {
        this.mode = mode;
    }

    public DesignTemplatesContainer withValidationMode(OperationMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public Class<? extends DesignTemplates> getRuntimeClass(Long modelId) {
        return DesignTemplates.class;
    }

    @Override
    public int getShard() {
        return 0;
    }
}
