package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

@ParametersAreNonnullByDefault
public class DesignTemplatesContainerImpl {
    private String siteVersion;
    private Boolean validateAsManager;
    private Set<DesignTemplatesType> availableDesignTypes;


    public Set<DesignTemplatesType> getAvailableDesignTypes() {
        return availableDesignTypes;
    }

    public void setAvailableDesignTypes(Set<DesignTemplatesType> availableDesignTypes) {
        this.availableDesignTypes = availableDesignTypes;
    }

    public String getSiteVersion() {
        return siteVersion;
    }

    public void setSiteVersion(String siteVersion) {
        this.siteVersion = siteVersion;
    }

    public Boolean getValidateAsManager() {
        return validateAsManager;
    }

    public void setValidateAsManager(Boolean validateAsManager) {
        this.validateAsManager = validateAsManager;
    }

    public DesignTemplatesContainerImpl withSiteVersion(String siteVersion) {
        this.siteVersion = siteVersion;
        return this;
    }

    public DesignTemplatesContainerImpl withAvailableDesignTypes(Set<DesignTemplatesType> types) {
        this.availableDesignTypes = types;
        return this;
    }

    public DesignTemplatesContainerImpl withValidateAsManager(Boolean validateAsManager) {
        this.validateAsManager = validateAsManager;
        return this;
    }




}
