package ru.yandex.partner.core.entity.block.type.designtemplates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplatesAndDependsFields;


@ParametersAreNonnullByDefault
@Component
// Internal and External rtb
public class RtbBlockDesignTemplatesAndDependsFieldsValidationTypeSupport extends
        AbstractBlockWithDesignTemplatesAndDependsFieldsValidationTypeSupport
                <BlockWithDesignTemplatesAndDependsFields> {

    private final BlockContainerFiller blockContainerFiller;
    private final BlockWithDesignTemplatesAndDependsFieldsValidatorProvider validatorProvider;

    @Autowired
    public RtbBlockDesignTemplatesAndDependsFieldsValidationTypeSupport(
            BlockWithDesignTemplatesAndDependsFieldsValidatorProvider provider,
            BlockContainerFiller blockContainerFiller) {
        super(provider);
        this.validatorProvider = provider;
        this.blockContainerFiller = blockContainerFiller;
    }

    @Override
    public Class<BlockWithDesignTemplatesAndDependsFields> getTypeClass() {
        return BlockWithDesignTemplatesAndDependsFields.class;
    }

    @Override
    public void fillContainer(BlockContainer container,
                              List<BlockWithDesignTemplatesAndDependsFields> models) {
        blockContainerFiller.fillFeaturesAndOptions(container, models);

        var siteVersions = new HashMap<Long, String>();
        var showVideo = new HashMap<Long, Boolean>();
        for (var model : models) {
            siteVersions.put(model.getId(), model.getSiteVersion());
            if (Objects.nonNull(model.getShowVideo())) {
                showVideo.put(model.getId(), model.getShowVideo());
            }
        }

        container.setSiteVersions(siteVersions);
        container.setShowVideo(showVideo);
    }

    @Override
    public ValidationResult<List<ModelChanges<BlockWithDesignTemplatesAndDependsFields>>, Defect>
        updateValidateBeforeApply(BlockContainer container,
                              ValidationResult<List<ModelChanges<BlockWithDesignTemplatesAndDependsFields>>, Defect> vr,
                              Map<Long, BlockWithDesignTemplatesAndDependsFields> unmodifiedValidModels) {

        ValidationResult<List<ModelChanges<BlockWithDesignTemplatesAndDependsFields>>, Defect> result =
                new ListValidationBuilder<>(vr)
                .checkEachBy(
                        validatorProvider.validatorBeforeApply(vr.getValue(), unmodifiedValidModels, container))
                            .getResult();

        return super.updateValidateBeforeApply(container, result, unmodifiedValidModels);
    }
}
