package ru.yandex.partner.core.entity.block.type.designtemplates.designsettings;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.service.msf.FormatSystemService;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

@ParametersAreNonnullByDefault
public class DesignSettingsValidatorFactory {

    private DesignSettingsValidatorFactory() {
    }

    public static Validator<Map<String, Object>, Defect> getValidator(DesignTemplatesType type,
                                                                      FormatSystemService formatSystemService,
                                                                      DesignSettingsValidatorHelper helper,
                                                                      String siteVersion, OperationMode mode,
                                                                      Map<String, Object> unmodifiedSettings,
                                                                      boolean canValidateAsManager) {
        switch (type) {
            case tga:
                return new TgaDesignSettingsValidator(formatSystemService, helper, siteVersion, mode,
                        unmodifiedSettings, canValidateAsManager);
            case native_:
                return new NativeDesignSettingsValidator();
            case media:
                return new MediaDesignSettingsValidator(formatSystemService, helper, siteVersion);
            default:
                return ValidationResult::success;
        }
    }
}
