package ru.yandex.partner.core.entity.block.type.designtemplates.designsettings;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.service.msf.dto.FormatSettingDto;
import ru.yandex.partner.core.service.msf.dto.FormatWithSettingsDto;

import static ru.yandex.partner.core.CoreConstants.DESIGN_SETTING_FLOORAD_PARAM;
import static ru.yandex.partner.core.CoreConstants.DESIGN_SETTING_LIMIT_PARAM;

@Service
public class DesignSettingsValidatorHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(DesignSettingsValidatorHelper.class);
    private Logger logger;

    protected Object getDefaultFromFormat(String designSettingLimitParam, FormatWithSettingsDto format) {
        if (format == null) {
            return null;
        }
        for (var settingDto : format.getSettings()) {
            if (settingDto.getName().equals(designSettingLimitParam)) {
                switch (designSettingLimitParam) {
                    case DESIGN_SETTING_LIMIT_PARAM:
                        return getLimit(settingDto);
                    case DESIGN_SETTING_FLOORAD_PARAM:
                        return getBoolean(settingDto);
                    default:
                        return null;
                }
            }
        }
        return null;
    }


    protected Integer getLimit(FormatSettingDto settingDto) {
        Object value = settingDto.getType().getValue();
        if (value == null) {
            logger.error("Limit is null. FormatSettingDto.name={}", settingDto.getName());
            return null;
        }

        if (value instanceof Number numValue) {
            return numValue.intValue();
        } else if (value instanceof String strValue) {
            try {
                return Integer.valueOf(strValue);
            } catch (NumberFormatException e) {
                logger.error("Limit is invalid number. FormatSettingDto.name={}", settingDto.getName(), e);
                return null;
            }
        } else {
            logger.error("Limit has unknown type. FormatSettingDto.name={}, value={}, class={}",
                    settingDto.getName(), value, value.getClass());
            return null;
        }
    }

    protected Boolean getBoolean(FormatSettingDto settingDto) {
        Object value = settingDto.getType().getValue();
        if (value == null) {
            logger.error("Value is null. FormatSettingDto.name={}", settingDto.getName());
            return null;
        }
        if (value instanceof Boolean boolVal) {
            return boolVal;
        } else if (value instanceof Number numValue) {
            return numValue.intValue() == 1;
        } else if (value instanceof String strValue) {
            return Boolean.valueOf(strValue);
        } else {
            logger.error("Value has unknown type. FormatSettingDto.name={}, value={}, class={}",
                    settingDto.getName(), value, value.getClass());
            return null;
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}
