package ru.yandex.partner.core.entity.block.type.directblock

import org.springframework.stereotype.Component
import ru.yandex.partner.core.block.direct.DirectBlocks
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport

@Component
class BlockWithDirectBlockAddOperationTypeSupport : AbstractBlockAddOperationTypeSupport<BlockWithDirectBlock>() {
    override fun onPreValidated(addContainer: BlockContainer, models: MutableList<BlockWithDirectBlock>) {
        models.forEach {
            if (it.directBlock == null) {
                it.directBlock = DirectBlocks.getDefault(it.blockType)
            }
        }
    }


    override fun getTypeClass() = BlockWithDirectBlock::class.java
}
