package ru.yandex.partner.core.entity.block.type.directblock;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithDirectBlockRepositoryTypeSupport extends
        AbstractBlockRepositoryTypeSupportWithMapper<BlockWithDirectBlock>
        implements CoreModelProvider<BlockWithDirectBlock> {

    private static final CoreModel<BlockWithDirectBlock> CORE_MODEL = CoreModel.forClass(BlockWithDirectBlock.class)
            .property(BlockWithDirectBlock.DIRECT_BLOCK)
            .build();

    private final JooqMapper<BlockWithDirectBlock> mapper;

    @Autowired
    public BlockWithDirectBlockRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = JooqMapperBuilder.<BlockWithDirectBlock>builder()
                .map(property(BlockWithDirectBlock.DIRECT_BLOCK, CONTEXT_ON_SITE_RTB.DIRECT_BLOCK))
                .build();
    }

    @Override
    public JooqMapper<BlockWithDirectBlock> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithDirectBlock> getTypeClass() {
        return BlockWithDirectBlock.class;
    }

    @Override
    public CoreModel<BlockWithDirectBlock> getCoreModel() {
        return CORE_MODEL;
    }
}
