package ru.yandex.partner.core.entity.block.type.directblock;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

public class BlockWithDirectBlockValidationTypeSupport extends
        AbstractBlockValidationTypeSupport<BlockWithDirectBlock> {

    private final Validator<BlockWithDirectBlock, Defect> validator;

    @Autowired
    public BlockWithDirectBlockValidationTypeSupport(BlockWithDirectBlockValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithDirectBlock> getTypeClass() {
        return BlockWithDirectBlock.class;
    }

    @Override
    public ValidationResult<List<BlockWithDirectBlock>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithDirectBlock>, Defect> vr) {
        return new ListValidationBuilder<>(vr).checkEachBy(validator).getResult();
    }
}
