package ru.yandex.partner.core.entity.block.type.directblock;


import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.block.direct.DirectBlock;
import ru.yandex.partner.core.block.direct.DirectBlocks;
import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class BlockWithDirectBlockValidatorProvider {

    public <M extends BlockWithDirectBlock> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithDirectBlock.DIRECT_BLOCK)
                    .check(notNull())
                    .checkByFunction(it -> {
                        DirectBlock directBlock = DirectBlocks.byName(it);
                        if (directBlock != null && directBlock.isAllowedBlockType(block)) {
                            return null;
                        }
                        return new Defect<>(BlockDefectIds.DirectBlockDefects.INVALID_DIRECT_BLOCK_TYPE);
                    });
            return vb.getResult();
        };
    }
}
