package ru.yandex.partner.core.entity.block.type.dspblocks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocks;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.entity.media.MediaSize;
import ru.yandex.partner.core.entity.media.MediaSizeRepository;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.FunctionalUtils;

import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;

@Component
@ParametersAreNonnullByDefault
public class BlockWithDspBlocksRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithDspBlocks>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithDspBlocks>,
        CoreModelProvider<BlockWithDspBlocks> {
    private static final CoreModel<BlockWithDspBlocks> CORE_MODEL = CoreModel.forClass(BlockWithDspBlocks.class)
            .property(ModelPropertyDefault.<BlockWithDspBlocks, List<String>>forProperty(BlockWithDspBlocks.DSP_BLOCKS)
                    .withDefaultValueOnAdd(List.of()))
            .build();

    private final MediaSizeRepository mediaSizeRepository;
    private final Set<ModelProperty<? super BlockWithDspBlocks, ?>> affectedModelProperties;
    private final Set<ModelProperty<? super BlockWithDspBlocks, ?>> editableModelProperties;

    public BlockWithDspBlocksRepositoryTypeSupport(DSLContext dslContext, MediaSizeRepository mediaSizeRepository) {
        super(dslContext);
        this.mediaSizeRepository = mediaSizeRepository;
        this.affectedModelProperties = Set.of(BlockWithDspBlocks.DSP_BLOCKS);
        this.editableModelProperties = Set.of(BlockWithDspBlocks.DSP_BLOCKS);
    }

    @Override
    public Set<ModelProperty<? super BlockWithDspBlocks, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithDspBlocks model) {
        return fromModelProperties(new HashSet<>(editableModelProperties));
    }

    @Override
    public Class<BlockWithDspBlocks> getTypeClass() {
        return BlockWithDspBlocks.class;
    }

    @Override
    public void insertToAdditionTables(DSLContext context, BlockContainer addModelParametersContainer,
                                       Collection<BlockWithDspBlocks> models) {
        mediaSizeRepository.addMediaSizes(context, StreamEx.of(models).toMap(block ->
                new PageBlockIds(block.getPageId(), block.getBlockId()), BlockWithDspBlocks::getDspBlocks));
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithDspBlocks> models) {
        Map<PageBlockIds, List<MediaSize>> mediaSizesByPageBlockIds = mediaSizeRepository.getMediaSizes(dslContext,
                FunctionalUtils.mapList(models, block -> new PageBlockIds(block.getPageId(), block.getBlockId()))
        );

        for (BlockWithDspBlocks block : models) {
            List<MediaSize> mediaSizes = mediaSizesByPageBlockIds.getOrDefault(
                    new PageBlockIds(block.getPageId(), block.getBlockId()),
                    List.of()
            );

            block.setDspBlocks(
                    mediaSizes.stream().map(MediaSize::getMediaSize).collect(Collectors.toList())
            );
        }
    }

    @Override
    public CoreModel<BlockWithDspBlocks> getCoreModel() {
        return CORE_MODEL;
    }
}
