package ru.yandex.partner.core.entity.block.type.dspblocks;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocks;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.media.MediaSizeRepository;

@Component
public class BlockWithDspBlocksUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithDspBlocks> {

    private static final Set<ModelProperty<? super BlockWithDspBlocks, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithDspBlocks.DSP_BLOCKS);
    private final MediaSizeRepository mediaSizeRepository;

    @Autowired
    public BlockWithDspBlocksUpdateOperationTypeSupport(
            MediaSizeRepository mediaSizeRepository,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade) {
        super(blockRepositoryTypeSupportFacade);
        this.mediaSizeRepository = mediaSizeRepository;
    }

    @Override
    public Class<BlockWithDspBlocks> getTypeClass() {
        return BlockWithDspBlocks.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(
            DSLContext dslContext,
            BlockContainer updateContainer,
            List<AppliedChanges<BlockWithDspBlocks>> appliedChanges) {

        mediaSizeRepository.updateMediaSizes(dslContext,
                appliedChanges.stream().map(AppliedChanges::getModel).collect(Collectors
                        .toMap(block -> new PageBlockIds(block.getPageId(), block.getBlockId()),
                                BlockWithDspBlocks::getDspBlocks)));

    }

    @Override
    public Set<ModelProperty<? super BlockWithDspBlocks, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
