package ru.yandex.partner.core.entity.block.type.dspblocksandsiteversion;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocksAndSiteVersion;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithDspBlocksAndSiteVersionValidateTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithDspBlocksAndSiteVersion> {

    private final Validator<BlockWithDspBlocksAndSiteVersion, Defect> validator;

    public BlockWithDspBlocksAndSiteVersionValidateTypeSupport(
            BlockWithDspBlocksAndSiteVersionValidatorProvider validatorProvider) {

        this.validator = validatorProvider.validator();
    }

    @Override
    public ValidationResult<List<BlockWithDspBlocksAndSiteVersion>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithDspBlocksAndSiteVersion>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

    @Override
    public Class<BlockWithDspBlocksAndSiteVersion> getTypeClass() {
        return BlockWithDspBlocksAndSiteVersion.class;
    }
}
