package ru.yandex.partner.core.entity.block.type.dspblocksandsiteversion;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocks;
import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocksAndSiteVersion;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.DspBlocksDefectParams;
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.core.i18n.entity.block.type.dspblocks.DspBlocksEnum;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithDspBlocksAndSiteVersionValidatorProvider {

    public static final List<DspBlockData> MEDIA_BLOCKS = List.of(
            new DspBlockData("1000x120", DspBlocksEnum._1000x120, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral())),

            new DspBlockData("160x600", DspBlocksEnum._160x600, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("240x600", DspBlocksEnum._240x600, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("240x400", DspBlocksEnum._240x400, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("300x600", DspBlocksEnum._300x600, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("300x500", DspBlocksEnum._300x500, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("300x300", DspBlocksEnum._300x300, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),

            new DspBlockData("300x250", DspBlocksEnum._300x250, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),
            new DspBlockData("320x50", DspBlocksEnum._320x50, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("320x100", DspBlocksEnum._320x100, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("336x280", DspBlocksEnum._336x280, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),


            new DspBlockData("728x90", DspBlocksEnum._728x90, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("970x250", DspBlocksEnum._970x250, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                    SiteVersionType.MOBILE_REWARDED.getLiteral(),
                    SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),
            new DspBlockData("970x90", DspBlocksEnum._970x90, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral())),

            new DspBlockData("100%x250", DspBlocksEnum._100_PERCENT_x250,
                    List.of(SiteVersionType.DESKTOP.getLiteral(),
                            SiteVersionType.TURBO_DESKTOP.getLiteral(),
                            SiteVersionType.MOBILE.getLiteral(),
                            SiteVersionType.TURBO.getLiteral(),
                            SiteVersionType.AMP.getLiteral(),
                            SiteVersionType.MOBILE_FLOORAD.getLiteral(),
                            SiteVersionType.MOBILE_REWARDED.getLiteral(),
                            SiteVersionType.MOBILE_FULLSCREEN.getLiteral())),
            new DspBlockData("100%x200", DspBlocksEnum._100_PERCENT_x200,
                    List.of(SiteVersionType.DESKTOP.getLiteral(),
                            SiteVersionType.TURBO_DESKTOP.getLiteral(),
                            SiteVersionType.MOBILE.getLiteral(),
                            SiteVersionType.TURBO.getLiteral(),
                            SiteVersionType.AMP.getLiteral(),
                            SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("100%x180", DspBlocksEnum._100_PERCENT_x180,
                    List.of(SiteVersionType.DESKTOP.getLiteral(),
                            SiteVersionType.TURBO_DESKTOP.getLiteral(),
                            SiteVersionType.MOBILE.getLiteral(),
                            SiteVersionType.TURBO.getLiteral(),
                            SiteVersionType.AMP.getLiteral(),
                            SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("100%x120", DspBlocksEnum._100_PERCENT_x120,
                    List.of(SiteVersionType.DESKTOP.getLiteral(),
                            SiteVersionType.TURBO_DESKTOP.getLiteral(),
                            SiteVersionType.MOBILE.getLiteral(),
                            SiteVersionType.TURBO.getLiteral(),
                            SiteVersionType.AMP.getLiteral(),
                            SiteVersionType.MOBILE_FLOORAD.getLiteral())),
            new DspBlockData("100%x90", DspBlocksEnum._100_PERCENT_x90, List.of(SiteVersionType.DESKTOP.getLiteral(),
                    SiteVersionType.TURBO_DESKTOP.getLiteral(),
                    SiteVersionType.MOBILE.getLiteral(),
                    SiteVersionType.TURBO.getLiteral(),
                    SiteVersionType.AMP.getLiteral(),
                    SiteVersionType.MOBILE_FLOORAD.getLiteral()))
    );
    // Ключ SiteVersion
    // Знеачение список допустимых DspBlocks id
    private final Map<String, Set<String>> siteVersionDspBlocksMap;
    private final Set<String> allTypes;

    public BlockWithDspBlocksAndSiteVersionValidatorProvider() {
        this.siteVersionDspBlocksMap = new HashMap<>();
        for (DspBlockData dspBlockListDatum : MEDIA_BLOCKS) {
            for (String siteVersion : dspBlockListDatum.getSiteVersions()) {
                siteVersionDspBlocksMap.putIfAbsent(siteVersion, new HashSet<>());
                siteVersionDspBlocksMap.get(siteVersion).add(dspBlockListDatum.getId());
            }
        }
        allTypes = StreamEx.of(siteVersionDspBlocksMap.values()).flatMap(Collection::stream).toSet();
    }

    public <M extends BlockWithDspBlocksAndSiteVersion> Validator<M, Defect> validator() {
        return block -> {
            var validationBuilder = ModelItemValidationBuilder.of(block);

            var invalidDspDefect = new Defect<>(BlockDefectIds.DspBlocks.INVALID_DSP_BLOCK_TYPES);
            validationBuilder.list(BlockWithDspBlocks.DSP_BLOCKS)
                    .check(notNull(), invalidDspDefect)
                    .check(CollectionConstraints.notEmptyCollection(), invalidDspDefect, When.isValid())
                    .checkEach(StringConstraints.maxStringLength(12), When.isValid())
                    .check(strings -> {
                        var unique = new HashSet<String>(strings.size());
                        var duplicates = new HashSet<String>(strings.size());
                        for (String string : strings) {
                            if (unique.contains(string)) {
                                duplicates.add(string);
                            } else {
                                unique.add(string);
                            }
                        }
                        if (duplicates.isEmpty()) {
                            return null;
                        } else {
                            return new Defect<>(BlockDefectIds.DspBlocks.HAS_DUPLICATES,
                                    new DspBlocksDefectParams().withDuplicates(duplicates));
                        }
                    }, When.isValid());

            validationBuilder.item(BlockWithDspBlocks.DSP_BLOCKS)
                    .check(dspBlocks -> {
                        var badDspBlocks = new HashSet<String>(dspBlocks.size());
                        for (String dspBlock : dspBlocks) {
                            if (!isAllowedDspBlock(block, dspBlock)) {
                                badDspBlocks.add(dspBlock);
                            }
                        }

                        if (badDspBlocks.isEmpty()) {
                            return null;
                        } else {
                            return new Defect<>(BlockDefectIds.DspBlocks.BAD_DSP_BLOCKS,
                                    new DspBlocksDefectParams().withBadBlocks(badDspBlocks));
                        }
                    }, When.isValid());

            return validationBuilder.getResult();
        };
    }

    private boolean isAllowedDspBlock(BlockWithDspBlocksAndSiteVersion block, String dspBlock) {
        var siteVersion = block.getSiteVersion();
        if (siteVersion != null && siteVersionDspBlocksMap.containsKey(siteVersion)) {
            return allTypes.contains(dspBlock);
        } else {
            return false;
        }
    }
}
