package ru.yandex.partner.core.entity.block.type.dspmode

import NPartner.Page
import one.util.streamex.StreamEx
import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithDspsDspsUnmoderatedDspModeStrategy
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.core.entity.dsp.DspConstants
import ru.yandex.partner.core.entity.dsp.model.Dsp
import java.math.BigDecimal
import java.util.function.Function

@Component
class BlockWithDspModeBkFillerconstructor :
    BlockBkFiller<BlockWithDspsDspsUnmoderatedDspModeStrategy> {

    private val hasCpmValue = setOf(
        CoreConstants.Strategies.MIN_CPM_STRATEGY_ID,
        CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID,
    )

    override fun getTypeClass(): Class<BlockWithDspsDspsUnmoderatedDspModeStrategy> {
        return BlockWithDspsDspsUnmoderatedDspModeStrategy::class.java
    }

    override fun fillBkData(
        block: BlockWithDspsDspsUnmoderatedDspModeStrategy,
        bkData: Page.TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        var mincpm = block.mincpm ?: BigDecimal.ZERO

        if (hasCpmValue.contains(block.strategyType)) {
            mincpm = mincpm.multiply(BigDecimal.valueOf(1000))
        }

        bkData.minCPM = mincpm.intValueExact()

        bkData.dspSettingsBuilder.setDSPBindMode(
            Page.TPartnerPage.TBlock.TDSPSettings.EDSPBindMode.valueOf(
                DspConstants.DspMode.fromBlock(
                    block
                ).bkLiteral
            )
        );

        bkData.dspSettingsBuilder.addAllDSP(
            StreamEx.of<Dsp>(block.dsps)
                .map<Long>(Function { obj: Dsp -> obj.id })
                .toList()
        )
        bkData.dspSettingsBuilder.addAllUnmoderated(block.dspsUnmoderated)
    }
}
