package ru.yandex.partner.core.entity.block.type.dspmode;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.jsonread.JsonReaderBuilders;
import ru.yandex.direct.jooqmapper.jsonwrite.JsonWriterBuilders;
import ru.yandex.partner.core.entity.block.model.BlockWithDspMode;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.dsp.DspConstants;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.convertibleJsonProperty;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithDspModeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithDspMode>
        implements CoreModelProvider<BlockWithDspMode> {
    private final JooqMapper<BlockWithDspMode> mapper;
    public static final CoreModel<BlockWithDspMode> MODEL = CoreModel.forClass(BlockWithDspMode.class)
            .property(ModelPropertyDefault.<BlockWithDspMode, String>forProperty(BlockWithDspMode.DSP_MODE)
                    .optional()
                    .withDefaultValueOnAdd(DspConstants.DspMode.FORCE.getLiteral())
            )
            .build();

    @Autowired
    protected BlockWithDspModeRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = JooqMapperBuilder.<BlockWithDspMode>builder()
                .map(convertibleJsonProperty(BlockWithDspMode.DSP_MODE, CONTEXT_ON_SITE_RTB.OPTS, "dsp_mode",
                        value -> {
                            var s = JsonReaderBuilders.jsonNodeToString(value);
                            return s != null ? s : DspConstants.DspMode.FORCE.getLiteral();
                        },
                        JsonWriterBuilders::stringToJsonNode
                ))
                .build();
    }

    @Override
    public JooqMapper<BlockWithDspMode> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithDspMode> getTypeClass() {
        return BlockWithDspMode.class;
    }

    @Override
    public CoreModel<BlockWithDspMode> getCoreModel() {
        return MODEL;
    }
}
