package ru.yandex.partner.core.entity.block.type.dspmode;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsDspsUnmoderatedDspModeStrategy;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithDspModeValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithDspsDspsUnmoderatedDspModeStrategy> {
    private final BlockWithDspModeValidatorProvider validatorProvider;

    @Autowired
    public BlockWithDspModeValidationTypeSupport(BlockWithDspModeValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BlockWithDspsDspsUnmoderatedDspModeStrategy> getTypeClass() {
        return BlockWithDspsDspsUnmoderatedDspModeStrategy.class;
    }

    @Override
    public ValidationResult<List<BlockWithDspsDspsUnmoderatedDspModeStrategy>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithDspsDspsUnmoderatedDspModeStrategy>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container))
                .getResult();
    }
}
