package ru.yandex.partner.core.entity.block.type.dspmode;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectIds;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsDspsUnmoderatedDspModeStrategy;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.dsp.DspConstants;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeDefined;

@Component
public class BlockWithDspModeValidatorProvider {

    public <M extends BlockWithDspsDspsUnmoderatedDspModeStrategy> Validator<M, Defect>
    validator(BlockContainer container) {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);

            vb.item(BlockWithDspsDspsUnmoderatedDspModeStrategy.DSP_MODE)
                    .check(notNull(), invalidTypeMustBeDefined())
                    .check(fromPredicate(
                            DspConstants.DspMode::dspModeExists,
                            new Defect<>(DefectIds.INVALID_VALUE)
                    ), When.isValid())
                    .check(l -> validateDspsList(block), When.isValid());

            return vb.getResult();
        };
    }

    private Defect validateDspsList(BlockWithDspsDspsUnmoderatedDspModeStrategy block) {
        if (DspConstants.DspMode.fromBlock(block).equals(DspConstants.DspMode.WHITELIST)
                || DspConstants.DspMode.fromBlock(block).equals(DspConstants.DspMode.FORCE)
//                || DspConstants.DspMode.fromBlock(block).equals(DspConstants.DspMode.BLACKLIST)
        ) {
            if (block.getDsps() != null && block.getDsps().isEmpty()) {
                return new Defect<>(BlockDefectIds.Dsps.EMPTY_BLACK_WHITE_LIST);
            }
        }
        return null;
    }
}
