package ru.yandex.partner.core.entity.block.type.dsps;

import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.dsp.model.Dsp;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints.isZeroOrGreaterIntegerNumber;

public class BlockDspsItemValidator implements DefaultValidator<Dsp> {
    @Override
    public ValidationResult<Dsp, Defect> apply(Dsp blockDsp) {
        ModelItemValidationBuilder<Dsp> vb = ModelItemValidationBuilder.of(blockDsp);

        vb.item(Dsp.ID)
                .check(notNull())
                .check(isZeroOrGreaterIntegerNumber(), When.notNull());
        vb.item(Dsp.UNMODERATED_RTB_AUCTION)
                .check(notNull());

        return vb.getResult();
    }
}
