package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.List;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;
import ru.yandex.partner.core.entity.dsp.model.Dsp;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeDefined;

public class BlockDspsListValidator implements DefaultValidator<List<Dsp>> {
    public BlockDspsListValidator() {
    }

    @Override
    public ValidationResult<List<Dsp>, Defect> apply(List<Dsp> blockDsps) {
        ListValidationBuilder<Dsp, Defect> vb = ListValidationBuilder.of(blockDsps);

        return vb
                .check(notNull(), invalidTypeMustBeDefined())
                .checkEachBy(new BlockDspsItemValidator(), When.isValid())
                .getResult();
    }
}
