package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDsps;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsAndInternalContextPage;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.service.DspService;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;

@Component
@ParametersAreNonnullByDefault
public class BlockWithDspsAndInternalContextPageAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithDspsAndInternalContextPage> {

    private final DspService dspService;

    @Autowired
    public BlockWithDspsAndInternalContextPageAddOperationTypeSupport(DspService dspService) {

        this.dspService = dspService;
    }

    @Override
    public Class<BlockWithDspsAndInternalContextPage> getTypeClass() {
        return BlockWithDspsAndInternalContextPage.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithDspsAndInternalContextPage> models) {
        // для гарантии что page завполниться раньше
        enrichPage(addContainer, models);

        for (BlockWithDspsAndInternalContextPage model : models) {
            if (model.getShowVideo() == null) {
                model.setShowVideo(false);
            }
        }

        var modelsWithoutDsp = models.stream()
                .filter(model -> model.getDsps() == null)
                .collect(Collectors.toList());

        // todo при удалении раскоментировать BlockWithContextPageAddOperationTypeSupport.class
        List<List<Dsp>> dsps = dspService.getDefaultDsps(modelsWithoutDsp);
        if (dsps.size() != modelsWithoutDsp.size()) {
            throw new IllegalStateException("Size must be equal. Dsps.size = "
                    + dsps.size() + ", BlockWithDsps.size = " + modelsWithoutDsp.size());
        }

        var dspIterator = dsps.iterator();

        for (BlockWithDsps model : modelsWithoutDsp) {
            model.setDsps(dspIterator.next());
        }
    }

    public <B extends BlockWithDspsAndInternalContextPage> void enrichPage(BlockContainer addContainer,
                                                                           Collection<B> models) {
        for (BlockWithDspsAndInternalContextPage model : models) {
            model.setCampaign((InternalContextPage) addContainer.getReachablePages()
                    .get(model.getClass())
                    .get(model.getPageId())
            );
        }
    }
}
