package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDsps;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsAndInternalMobileApp;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.service.DspService;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;

@Component
@ParametersAreNonnullByDefault
public class BlockWithDspsAndInternalMobileAppAddOperationTypeSupport
        extends AbstractBlockAddOperationTypeSupport<BlockWithDspsAndInternalMobileApp> {

    private static final Set<String> SHOWS_VIDEO_BY_DEFAULT = Set.of(
            MobileBlockType.INTERSTITIAL.getLiteral(),
            MobileBlockType.BANNER.getLiteral(),
            MobileBlockType.ADAPTIVE_BANNER.getLiteral()
    );

    private final DspService dspService;

    @Autowired
    public BlockWithDspsAndInternalMobileAppAddOperationTypeSupport(DspService dspService) {
        this.dspService = dspService;
    }

    @Override
    public Class<BlockWithDspsAndInternalMobileApp> getTypeClass() {
        return BlockWithDspsAndInternalMobileApp.class;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<BlockWithDspsAndInternalMobileApp> models) {
        // для гарантии, что page заполнится раньше
        enrichPage(addContainer, models);

        // set show_video defaults before processing dsps defaults
        for (var block : models) {
            boolean showVideo;
            String blockType = block.getBlockType();
            if (MobileBlockType.NATIVE.getLiteral().equals(blockType)) {
                showVideo = false;
            } else if (SHOWS_VIDEO_BY_DEFAULT.contains(blockType)) {
                showVideo = Objects.requireNonNullElse(block.getShowVideo(), true);
            } else if (MobileBlockType.REWARDED.getLiteral().equals(blockType)) {
                showVideo = true;
            } else {
                throw new IllegalArgumentException("Unhandled block type: " + block.getBlockType());
            }
            block.setShowVideo(showVideo);
        }

        var modelsWithoutDsp = models.stream()
                .filter(model -> model.getDsps() == null)
                .collect(Collectors.toList());

        // todo при удалении раскоментировать BlockWithContextPageAddOperationTypeSupport.class
        List<List<Dsp>> dsps = dspService.getDefaultDsps(modelsWithoutDsp);
        if (dsps.size() != modelsWithoutDsp.size()) {
            throw new IllegalStateException("Size must be equal. Dsps.size = "
                    + dsps.size() + ", BlockWithDsps.size = " + modelsWithoutDsp.size());
        }

        var dspIterator = dsps.iterator();

        for (BlockWithDsps model : modelsWithoutDsp) {
            model.setDsps(dspIterator.next());
        }
    }

    public <B extends BlockWithDspsAndInternalMobileApp> void enrichPage(
            BlockContainer addContainer, Collection<B> models) {
        for (BlockWithDspsAndInternalMobileApp model : models) {
            model.setCampaign((InternalMobileApp) addContainer.getReachablePages()
                    .get(model.getClass())
                    .get(model.getPageId())
            );
        }
    }
}
