package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDsps;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.model.DspWithCommonFields;
import ru.yandex.partner.core.entity.dsp.model.DspWithFormats;
import ru.yandex.partner.core.entity.dsp.model.DspWithTypes;
import ru.yandex.partner.core.entity.dsp.repository.DspModifyRepository;
import ru.yandex.partner.core.entity.dsp.repository.DspTypedRepository;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.FunctionalUtils;

import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;

@Component
@ParametersAreNonnullByDefault
public class BlockWithDspsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithDsps>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithDsps>,
        CoreModelProvider<BlockWithDsps>,
        BlockBkFiller<BlockWithDsps> {
    public static final CoreModel<BlockWithDsps> MODEL = CoreModel.forClass(BlockWithDsps.class)
            .property(ModelPropertyDefault.forProperty(BlockWithDsps.DSPS))
            .build();
    public static final Set<ModelProperty<? extends Model, ?>> DSP_PROPS_FOR_BLOCK =
            Stream.<Set<ModelProperty<?, ?>>>of(
                    DspWithCommonFields.allModelProperties(),
                    DspWithFormats.allModelProperties(),
                    DspWithTypes.allModelProperties()
            ).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());

    private final DspTypedRepository dspTypedRepository;
    private final DspModifyRepository dspModifyRepository;
    private final Set<ModelProperty<? super BlockWithDsps, ?>> affectedModelProperties;
    private final Set<ModelProperty<? super BlockWithDsps, ?>> editableModelProperties;

    public BlockWithDspsRepositoryTypeSupport(DSLContext dslContext, DspTypedRepository dspTypedRepository,
                                              DspModifyRepository dspModifyRepository) {
        super(dslContext);
        this.dspTypedRepository = dspTypedRepository;
        this.dspModifyRepository = dspModifyRepository;
        this.affectedModelProperties = Set.of(BlockWithDsps.DSPS);
        this.editableModelProperties = Set.of(BlockWithDsps.DSPS);
    }

    @Override
    public Set<ModelProperty<? super BlockWithDsps, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithDsps model) {
        return fromModelProperties(new HashSet<>(editableModelProperties));
    }

    @Override
    public Class<BlockWithDsps> getTypeClass() {
        return BlockWithDsps.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithDsps> models) {
        Map<PageBlockIds, List<Dsp>> blockDspsByPageBlockIds = dspTypedRepository.getDspsForPageBlockIds(
                dslContext,
                FunctionalUtils.mapList(models, block -> new PageBlockIds(block.getPageId(), block.getBlockId())),
                DSP_PROPS_FOR_BLOCK
        );

        for (BlockWithDsps block : models) {
            PageBlockIds key = new PageBlockIds(block.getPageId(), block.getBlockId());
            block.setDsps(blockDspsByPageBlockIds.getOrDefault(key, List.of()));
        }
    }

    @Override
    public CoreModel<BlockWithDsps> getCoreModel() {
        return MODEL;
    }


    @Override
    public void insertToAdditionTables(DSLContext context, BlockContainer addModelParametersContainer,
                                       Collection<BlockWithDsps> models) {
        dspModifyRepository.addBlockDsps(context, StreamEx.of(models).toMap(it -> new PageBlockIds(it.getPageId(),
                it.getBlockId()), BlockWithDsps::getDsps));
    }

    @Override
    public void fillBkData(@NotNull BlockWithDsps model, @NotNull TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        model.getDsps().stream().sorted(Comparator.comparing(Dsp::getId))
                .forEachOrdered(dsp -> bkData.addDSPInfoBuilder().setDSPID(dsp.getId()).setCPM(0));
    }
}
