package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDsps;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.dsp.repository.DspModifyRepository;

@Component
public class BlockWithDspsUpdateOperationTypeSupport extends AbstractBlockUpdateOperationTypeSupport<BlockWithDsps> {

    private static final Set<ModelProperty<? super BlockWithDsps, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithDsps.DSPS);
    private final DspModifyRepository dspModifyRepository;

    @Autowired
    public BlockWithDspsUpdateOperationTypeSupport(
            DspModifyRepository dspModifyRepository,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade) {
        super(blockRepositoryTypeSupportFacade);
        this.dspModifyRepository = dspModifyRepository;
    }

    @Override
    public Class<BlockWithDsps> getTypeClass() {
        return BlockWithDsps.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   BlockContainer updateContainer,
                                                   List<AppliedChanges<BlockWithDsps>> appliedChanges) {

        // Не вписывается в Relation, так как нету айдишника в виде числа
        // Айдишник составной pageId-blockId-dspId и разбит в java по разным моделям
        // pageId и blockId в BlockWithDsps, а dspId внутри Dsp ( в List<Dsp> )

        var pageBlockIds = appliedChanges.stream()
                .map(appliedChange ->
                        new PageBlockIds(appliedChange.getModel().getPageId(), appliedChange.getModel().getBlockId()))
                .collect(Collectors.toList());

        dspModifyRepository.deleteBlockDsps(dslContext, pageBlockIds);

        var newDsps = appliedChanges.stream()
                .map(appliedChange -> {
                            var dsps = appliedChange.getNewValue(BlockWithDsps.DSPS);
                            if (dsps != null) {
                                return Map.entry(
                                        new PageBlockIds(
                                                appliedChange.getModel().getPageId(),
                                                appliedChange.getModel().getBlockId()
                                        ),
                                        dsps
                                );
                            } else {
                                return null;
                            }

                        }
                )
                .filter(Objects::nonNull)
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        dspModifyRepository.addBlockDsps(dslContext, newDsps);
    }

    @Override
    public Set<ModelProperty<? super BlockWithDsps, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }

}
