package ru.yandex.partner.core.entity.block.type.dsps;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDsps;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.service.DspService;

@Component
public class BlockWithDspsValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithDsps> {
    private final BlockWithDspsValidatorProvider validatorProvider;
    private final DspService dspService;

    @Autowired
    public BlockWithDspsValidationTypeSupport(BlockWithDspsValidatorProvider validatorProvider, DspService dspService) {

        this.validatorProvider = validatorProvider;
        this.dspService = dspService;
    }

    @Override
    public Class<BlockWithDsps> getTypeClass() {
        return BlockWithDsps.class;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithDsps> models) {
        if (container.getNotDeletedDsps() == null) {
            Map<Long, Dsp> dsps = StreamEx.of(dspService.getAllNotDeletedDsps())
                    .toMap(Dsp::getId, d -> d);
            container.setNotDeletedDsps(dsps);
        }

        if (container.getBlockAvailableDsps() == null) {
            container.setBlockAvailableDsps(dspService.getBlockAvailableDsps(models, container));
        }
    }

    @Override
    public ValidationResult<List<BlockWithDsps>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithDsps>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container))
                .getResult();
    }
}
