package ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype

import org.jooq.DSLContext
import org.jooq.Field
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.model.ModelProperty
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndDspsAndCommonShowVideo
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport

/**
 * Саппорт заведён, чтобы связать вычитку BlockType для BlockWithDspsAndShowVideoUpdateOperationTypeSupport
 * при удалении нужно как-то зафиксировать необходимость вычитки BlockType (возможно в самих рулах)
 */
@Component
class BlockWithBlockTypeDspsAndShowVideoRepositoryTypeSupport(dslContext: DSLContext) :
    AbstractBlockRepositoryTypeSupport<BlockWithBlockTypeAndDspsAndCommonShowVideo>(dslContext) {

    override fun getTypeClass() = BlockWithBlockTypeAndDspsAndCommonShowVideo::class.java

    override fun getFields(): MutableCollection<Field<*>> = mutableListOf()

    override fun getAffectedModelProperties() =
        setOf<ModelProperty<in BlockWithBlockTypeAndDspsAndCommonShowVideo, *>>(
            BlockWithBlockTypeAndDspsAndCommonShowVideo.DSPS,
            BlockWithBlockTypeAndDspsAndCommonShowVideo.SHOW_VIDEO,
            BlockWithBlockTypeAndDspsAndCommonShowVideo.BLOCK_TYPE
        )

    override fun getFields(modelProperties: MutableCollection<ModelProperty<*, *>>) = setOf<Field<*>>()

    override fun <M : BlockWithBlockTypeAndDspsAndCommonShowVideo?> fillFromRecord(model: M, record: Record) {
        // intentionally left blank
    }
}
