package ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowVideo;

import static ru.yandex.partner.core.block.MobileBlockType.BANNER;
import static ru.yandex.partner.core.block.MobileBlockType.INTERSTITIAL;
import static ru.yandex.partner.core.block.MobileBlockType.NATIVE;

@Service
public class InternalMobileShowVideoApplicableService
        implements ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> {

    @Override
    public boolean isShowVideoApplicable(BlockWithBlockTypeAndShowVideo block, boolean canEditRichMedia) {
        return NATIVE.hasType(block) || INTERSTITIAL.hasType(block) || BANNER.hasType(block);
    }

    @Override
    public boolean getDefaultValue(BlockWithBlockTypeAndShowVideo block) {
        return BANNER.hasType(block) || INTERSTITIAL.hasType(block);
    }
}
