package ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndDspsAndCommonShowVideo;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;

import static ru.yandex.partner.core.CoreConstants.VIDEO_BANNER_DSPS;
import static ru.yandex.partner.core.CoreConstants.VIDEO_INTERSTITIAL_DSPS;
import static ru.yandex.partner.core.block.MobileBlockType.BANNER;
import static ru.yandex.partner.core.block.MobileBlockType.INTERSTITIAL;
import static ru.yandex.partner.core.block.MobileBlockType.NATIVE;
import static ru.yandex.partner.core.block.MobileBlockType.REWARDED;


@Component
public class MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules
        extends BlockWithBlockTypeAndDspsAndCommonShowVideoDspRules {
    public MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules(
            MobileShowVideoApplicableService showVideoApplicableService) {
        super(showVideoApplicableService);
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return super.getDspRuleSet(container)
                .withRule(getSpecialShowVideoDspRule(container));
    }

    @Override
    public Set<Long> getDefaultVideoDsps(BlockWithBlockTypeAndDspsAndCommonShowVideo block) {
        if (Boolean.TRUE.equals(block.getShowVideo())) {
            var blockType = block.getBlockType();
            if (INTERSTITIAL.getLiteral().equals(blockType)) {
                return VIDEO_INTERSTITIAL_DSPS;
            } else if (BANNER.getLiteral().equals(blockType)
                    || REWARDED.getLiteral().equals(blockType)
                    || NATIVE.getLiteral().equals(blockType)) {
                return VIDEO_BANNER_DSPS;
            }
        }
        return Set.of();
    }
}
