package ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype;


import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowVideo;

import static ru.yandex.partner.core.block.MobileBlockType.BANNER;
import static ru.yandex.partner.core.block.MobileBlockType.INTERSTITIAL;
import static ru.yandex.partner.core.block.MobileBlockType.NATIVE;
import static ru.yandex.partner.core.block.MobileBlockType.REWARDED;

@Service
public class MobileShowVideoApplicableService
        implements ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> {

    @Override
    public boolean isShowVideoApplicable(BlockWithBlockTypeAndShowVideo block, boolean canEditRichMedia) {
        return NATIVE.hasType(block) && canEditRichMedia ||
                BANNER.hasType(block);
    }

    public boolean isSimpleInapp(BaseBlock block) {
        return true;
    }

    public boolean isSimpleInappByCampaignOwner(BaseBlock block) {
        return true;
    }

    @Override
    public boolean getDefaultValue(BlockWithBlockTypeAndShowVideo block) {
        boolean hasSimpleInapp = isSimpleInapp(block);
        var blockType = block.getBlockType();

        return ((BANNER.getLiteral().equals(blockType) && hasSimpleInapp)
                        || (INTERSTITIAL.getLiteral().equals(blockType))
                        || REWARDED.getLiteral().equals(blockType));
    }

}
