package ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion

import NPartner.Page.TPartnerPage.TBlock
import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithDspsShowVideoAndSiteVersion
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService

@Component
class BlockWithDspsShowVideoAndSiteVersionBkFiller
constructor(private val showVideoApplicableService: ShowVideoApplicableService) :
    BlockBkFiller<BlockWithDspsShowVideoAndSiteVersion> {

    override fun getTypeClass(): Class<BlockWithDspsShowVideoAndSiteVersion> {
        return BlockWithDspsShowVideoAndSiteVersion::class.java
    }


    override fun fillBkData(
        block: BlockWithDspsShowVideoAndSiteVersion,
        bkData: TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        val applicable = showVideoApplicableService.isShowVideoApplicableBySiteVersion(
            block.siteVersion,
            block.showVideo
        )

        val showVideo: Boolean
        if (applicable) {
            showVideo = block.showVideo
        } else {
            showVideo = showVideoApplicableService.getDefaultValueBySiteVersion(block.siteVersion)
        }

        if (showVideo) {
            bkData.dspType = bkData.dspType.or(2) // 2^1 video
        }
    }
}
