package ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion;

import ru.yandex.partner.core.entity.block.model.BlockWithDspsShowVideoAndSiteVersion;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.block.type.dspsshowvideo.BlockWithDspsShowVideoDspRules;


public abstract class BlockWithDspsShowVideoAndSiteVersionDspRules
        extends BlockWithDspsShowVideoDspRules<BlockWithDspsShowVideoAndSiteVersion> {
    private final ShowVideoApplicableService showVideoApplicableService;

    public BlockWithDspsShowVideoAndSiteVersionDspRules(ShowVideoApplicableService showVideoApplicableService) {
        this.showVideoApplicableService = showVideoApplicableService;
    }

    @Override
    public boolean isShowVideoApplicable(BlockWithDspsShowVideoAndSiteVersion block, boolean canEditRichMedia) {
        return showVideoApplicableService.isShowVideoApplicableBySiteVersion(
                block.getSiteVersion(),
                block.getShowVideo()
        );
    }

    @Override
    public boolean getDefaultShowVideo(BlockWithDspsShowVideoAndSiteVersion block) {
        return showVideoApplicableService.getDefaultValueBySiteVersion(block.getSiteVersion());
    }

    @Override
    public Class<BlockWithDspsShowVideoAndSiteVersion> getEntireTypeClass() {
        return null;
    }
}
