package ru.yandex.partner.core.entity.block.type.dspsshowvideo

import ru.yandex.partner.core.CoreConstants.DspFormats.BANNER
import ru.yandex.partner.core.CoreConstants.DspFormats.VIDEO
import ru.yandex.partner.core.block.MobileBlockType
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndDspsAndCommonShowVideo
import ru.yandex.partner.core.entity.dsp.model.Dsp
import ru.yandex.partner.core.entity.dsp.multistate.DspMultistateGraph
import ru.yandex.partner.core.entity.dsp.rules.DspRule
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.core.multistate.dsp.DspStateFlag
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB
import ru.yandex.partner.dbschema.partner.tables.Dsp.DSP
import ru.yandex.partner.dbschema.partner.tables.DspFormat.DSP_FORMAT

abstract class BlockWithBlockTypeAndShowVideoBannerDspRules(
    dspMultistateGraph: DspMultistateGraph,
    workingOnAllPlatformsStateFlag: DspStateFlag,
    val workingOnAllPlatformsMultistates: List<Long> = dspMultistateGraph
        .getMultistatesForPredicate(workingOnAllPlatformsStateFlag)
        .map { it.toMultistateValue() }
        .toList()
) :
    DspRuleComponent<BlockWithBlockTypeAndDspsAndCommonShowVideo>() {

    override fun getEntireTypeClass(): Class<BlockWithBlockTypeAndDspsAndCommonShowVideo>? {
        return null
    }

    override fun getDspRuleSet(container: DspRuleContainer): DspRuleSet {
        return DspRuleSet()
            .withRule(object : DspRule<BasePage, BlockWithBlockTypeAndDspsAndCommonShowVideo, Dsp>() {
                override fun defaultDsps(
                    dspRuleContainer: DspRuleContainer, page: BasePage,
                    block: BlockWithBlockTypeAndDspsAndCommonShowVideo
                ): DspRuleResult {
                    return if (block.blockType in TYPES) {
                        val formats = mutableListOf(BANNER)
                        if (block.showVideo) {
                            formats.add(VIDEO)
                        }
                        DspRuleResult.extend(
                            DSP_FORMAT.FORMAT_ID.`in`(formats)
                                .and(DSP.MULTISTATE.`in`(workingOnAllPlatformsMultistates))
                        )
                    } else {
                        DspRuleResult.limitIdentity()
                    }
                }

                override fun availableDsps(
                    dspRuleContainer: DspRuleContainer,
                    block: BlockWithBlockTypeAndDspsAndCommonShowVideo
                ): DspRuleResult {
                    val formats = mutableListOf(BANNER)
                    if (block.showVideo) {
                        formats.add(VIDEO)
                    }

                    return if (block.blockType in TYPES) {
                        DspRuleResult
                            .extend(
                                DSP_FORMAT.FORMAT_ID.`in`(formats)
                            )
                    } else {
                        DspRuleResult.limitIdentity()
                    }
                }

                override fun turnOnDsps(
                    dspRuleContainer: DspRuleContainer, page: BasePage,
                    block: BlockWithBlockTypeAndDspsAndCommonShowVideo, dsp: Dsp
                ): DspRuleResult {
                    return if (dsp.formats?.contains(BANNER) == true) {
                        DspRuleResult.extend(
                            CONTEXT_ON_SITE_RTB.BLOCK_TYPE
                                .`in`(MobileBlockType.NATIVE.literal, MobileBlockType.INTERSTITIAL.literal)
                        )
                    } else if (dsp.formats?.contains(VIDEO) == true) {
                        DspRuleResult.extend(
                            CONTEXT_ON_SITE_RTB.SHOW_VIDEO.eq(1L)
                                .and(
                                    CONTEXT_ON_SITE_RTB.BLOCK_TYPE
                                        .`in`(MobileBlockType.NATIVE.literal, MobileBlockType.INTERSTITIAL.literal)
                                )
                        )
                    } else {
                        DspRuleResult.extendZero()
                    }
                }
            })
    }

    companion object {
        private val TYPES: Set<String> = setOf(
            MobileBlockType.BANNER.literal,
            MobileBlockType.INTERSTITIAL.literal
        )
    }
}
