package ru.yandex.partner.core.entity.block.type.dspsshowvideo

import org.springframework.stereotype.Component
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.partner.core.block.BlockType
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.model.BlockWithDspsShowVideo
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport
import ru.yandex.partner.core.entity.dsp.service.DspService
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade

@Component
class BlockWithDspsAndShowVideoUpdateOperationTypeSupport(
    private val dspService: DspService,
    repositoryFacade: PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer>?,
) : AbstractBlockUpdateOperationTypeSupport<BlockWithDspsShowVideo>(repositoryFacade) {

    override fun onChangesApplied(
        updateContainer: BlockContainer,
        appliedChanges: List<AppliedChanges<BlockWithDspsShowVideo>>
    ) {
        dspService.dspsFieldEdit(appliedChanges, updateContainer)
    }

    override fun getTypeClass(): Class<BlockWithDspsShowVideo> {
        return BlockWithDspsShowVideo::class.java
    }
}
