package ru.yandex.partner.core.entity.block.type.dspsstrategy

import NPartner.Page.TPartnerPage.TBlock
import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithDspsAndStrategy
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import java.math.BigDecimal

@Component
class BlockWithDspsAndStrategyBkFiller : BlockBkFiller<BlockWithDspsAndStrategy> {
    private val hasCpmValue = setOf(
        CoreConstants.Strategies.MIN_CPM_STRATEGY_ID,
        CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID,
    )

    override fun fillBkData(
        block: BlockWithDspsAndStrategy,
        bkData: TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        var mincpm = block.mincpm ?: BigDecimal.ZERO

        if (hasCpmValue.contains(block.strategyType)) {
            mincpm = mincpm.multiply(BigDecimal.valueOf(1000))
        }

        bkData.dspInfoBuilderList.forEach { dsp -> dsp.cpm = mincpm.intValueExact() }
    }

    override fun getTypeClass(): Class<BlockWithDspsAndStrategy> {
        return BlockWithDspsAndStrategy::class.java
    }
}
