package ru.yandex.partner.core.entity.block.type.dspsunmoderated;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import com.google.common.collect.Sets;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsUnmoderated;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupport;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithoutMapper;
import ru.yandex.partner.core.entity.dsp.repository.DspModifyRepository;
import ru.yandex.partner.core.entity.dsp.repository.DspTypedRepository;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.utils.FunctionalUtils;

import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;

@Component
@ParametersAreNonnullByDefault
public class    BlockWithDspsUnmoderatedRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupport<BlockWithDspsUnmoderated>
        implements BlockRepositoryTypeSupportWithoutMapper<BlockWithDspsUnmoderated>,
        BlockBkFiller<BlockWithDspsUnmoderated> {
    public static final String DSP_OPTION_UNMODERATED_RTB_AUCTION = "unmoderated-rtb-auction";
    private final DspTypedRepository dspTypedRepository;
    private final DspModifyRepository dspModifyRepository;
    private final Set<ModelProperty<? super BlockWithDspsUnmoderated, ?>> affectedModelProperties;
    private final Set<ModelProperty<? super BlockWithDspsUnmoderated, ?>> editableModelProperties;

    public BlockWithDspsUnmoderatedRepositoryTypeSupport(DSLContext dslContext,
                                                         DspTypedRepository dspTypedRepository,
                                                         DspModifyRepository dspModifyRepository) {
        super(dslContext);
        this.dspTypedRepository = dspTypedRepository;
        this.dspModifyRepository = dspModifyRepository;
        this.affectedModelProperties = Set.of(BlockWithDspsUnmoderated.DSPS_UNMODERATED);
        this.editableModelProperties = Set.of(BlockWithDspsUnmoderated.DSPS_UNMODERATED);
    }

    @Override
    public Set<ModelProperty<? super BlockWithDspsUnmoderated, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithDspsUnmoderated model) {
        return fromModelProperties(new HashSet<>(editableModelProperties));
    }

    @Override
    public Class<BlockWithDspsUnmoderated> getTypeClass() {
        return BlockWithDspsUnmoderated.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithDspsUnmoderated> models) {
        Map<PageBlockIds, List<Long>> dspsUnmoderatedByPageBlockIds =
                dspTypedRepository.getDspsUnmoderatedForPageBlockIds(
                        dslContext,
                        FunctionalUtils.mapList(models,
                                block -> new PageBlockIds(block.getPageId(), block.getBlockId())
                        )
                );

        for (BlockWithDspsUnmoderated block : models) {
            PageBlockIds key = new PageBlockIds(block.getPageId(), block.getBlockId());
            block.setDspsUnmoderated(dspsUnmoderatedByPageBlockIds.getOrDefault(key, List.of()));
        }
    }

    @Override
    public void insertToAdditionTables(DSLContext context, BlockContainer addModelParametersContainer,
                                       Collection<BlockWithDspsUnmoderated> models) {
        dspModifyRepository.addBlockDspsUnmoderated(context,
                StreamEx.of(models)
                        .filter(model -> model.getDspsUnmoderated() != null)
                        .toMap(it -> new PageBlockIds(it.getPageId(),
                                it.getBlockId()), BlockWithDspsUnmoderated::getDspsUnmoderated));
    }

    @Override
    public void fillBkData(@NotNull BlockWithDspsUnmoderated model,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        if (model.getDspsUnmoderated().isEmpty()) {
            return;
        }

        var unmoderatedDsps = Sets.newHashSetWithExpectedSize(model.getDspsUnmoderated().size());
        unmoderatedDsps.addAll(model.getDspsUnmoderated());
        for (TPartnerPage.TBlock.TDSPInfo.Builder dspBuilder : bkData.getDSPInfoBuilderList()) {
            if (unmoderatedDsps.contains(dspBuilder.getDSPID())) {
                dspBuilder.getPageDspOptionsBuilder()
                        .addEnable(DSP_OPTION_UNMODERATED_RTB_AUCTION);
            } else {
                dspBuilder.getPageDspOptionsBuilder()
                        .addDisable(DSP_OPTION_UNMODERATED_RTB_AUCTION);
            }
        }
    }
}
