package ru.yandex.partner.core.entity.block.type.dspsunmoderated;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsUnmoderated;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.entity.dsp.repository.DspModifyRepository;

@Component
public class BlockWithDspsUnmoderatedUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithDspsUnmoderated> {

    private static final Set<ModelProperty<? super BlockWithDspsUnmoderated, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithDspsUnmoderated.DSPS_UNMODERATED);
    private final DspModifyRepository dspModifyRepository;

    @Autowired
    public BlockWithDspsUnmoderatedUpdateOperationTypeSupport(
            DspModifyRepository dspModifyRepository,
            BlockRepositoryTypeSupportFacade repositoryTypeSupportFacade) {
        super(repositoryTypeSupportFacade);
        this.dspModifyRepository = dspModifyRepository;
    }

    @Override
    public Class<BlockWithDspsUnmoderated> getTypeClass() {
        return BlockWithDspsUnmoderated.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   BlockContainer updateContainer,
                                                   List<AppliedChanges<BlockWithDspsUnmoderated>> appliedChanges) {

        // Не вписывается в Relation, так как нету айдишника в виде числа
        // Айдишник составной pageId-blockId-dspId и разбит в java по разным моделям
        // pageId и blockId в BlockWithDsps, а dspId внутри Dsp ( в List<Dsp> )

        var pageBlockIds = appliedChanges.stream()
                .map(appliedChange ->
                        new PageBlockIds(appliedChange.getModel().getPageId(), appliedChange.getModel().getBlockId()))
                .collect(Collectors.toList());

        dspModifyRepository.deleteBlockDspsUnmoderated(dslContext, pageBlockIds);

        var newDsps = appliedChanges.stream()
                .map(appliedChange -> {
                            var dsps = appliedChange.getNewValue(BlockWithDspsUnmoderated.DSPS_UNMODERATED);
                            if (dsps != null) {
                                return Map.entry(
                                        new PageBlockIds(
                                                appliedChange.getModel().getPageId(),
                                                appliedChange.getModel().getBlockId()
                                        ),
                                        dsps
                                );
                            } else {
                                return null;
                            }

                        }
                )
                .filter(Objects::nonNull)
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        dspModifyRepository.addBlockDspsUnmoderated(dslContext, newDsps);
    }

    @Override
    public Set<ModelProperty<? super BlockWithDspsUnmoderated, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}

