package ru.yandex.partner.core.entity.block.type.dspsunmoderated;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsUnmoderated;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.dsp.service.DspService;

@Component
public class BlockWithDspsUnmoderatedValidationTypeSupport extends
        AbstractBlockValidationTypeSupport<BlockWithDspsUnmoderated> {
    private final BlockWithDspsUnmoderatedValidatorProvider validatorProvider;
    private final DspService dspService;


    @Autowired
    public BlockWithDspsUnmoderatedValidationTypeSupport(DspService dspService,
                                                         BlockWithDspsUnmoderatedValidatorProvider validatorProvider
    ) {

        this.dspService = dspService;
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BlockWithDspsUnmoderated> getTypeClass() {
        return BlockWithDspsUnmoderated.class;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithDspsUnmoderated> models) {
        if (container.getNotDeletedDsps() == null) {
            Map<Long, Dsp> dsps = StreamEx.of(dspService.getAllNotDeletedDsps())
                    .toMap(Dsp::getId, d -> d);

            container.setNotDeletedDsps(dsps);
        }
    }

    @Override
    public ValidationResult<List<BlockWithDspsUnmoderated>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithDspsUnmoderated>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container))
                .getResult();
    }
}
