package ru.yandex.partner.core.entity.block.type.dspsunmoderated;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithContextPage;
import ru.yandex.partner.core.entity.block.model.BlockWithDspsUnmoderated;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.DspsUnmoderatedDefectParams;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.page.model.ContextPage;

@Component
public class BlockWithDspsUnmoderatedValidatorProvider {

    public <M extends BlockWithDspsUnmoderated> Validator<M, Defect> validator(BlockContainer container) {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);

            vb.item(BlockWithDspsUnmoderated.DSPS_UNMODERATED)
                    .checkByFunction(l -> validateUnmoderatedDspsList(block, l, container), When.notNull());

            return vb.getResult();
        };
    }

    private Defect validateUnmoderatedDspsList(BlockWithDspsUnmoderated block,
                                               List<Long> unmoderatedDspIds,
                                               BlockContainer container) {
        if (unmoderatedDspIds == null || unmoderatedDspIds.isEmpty()) {
            return null;
        }

        if (block instanceof BlockWithContextPage) {
            //TODO : PI-24357 в рамках этой задачи необходимо брать эти данные из контейнера
            ContextPage campaign = ((BlockWithContextPage) block).getCampaign();
            if (Objects.equals(campaign.getUnmoderatedRtbAuction(), Boolean.FALSE)) {
                return null;
            }
        }

        Map<Long, Dsp> allDsps = container.getNotDeletedDsps();
        if (allDsps == null) {
            throw new RuntimeException("Dsps map is not set");
        }

        var unmoderatedDsps = StreamEx.of(allDsps.values())
                .filter(dsp -> Objects.equals(dsp.getUnmoderatedRtbAuction(), Boolean.TRUE))
                .map(Dsp::getId)
                .collect(Collectors.toSet());

        List<Long> nonUnnmoderatedDsps = StreamEx.of(unmoderatedDspIds)
                .filter(d -> !unmoderatedDsps.contains(d))
                .toList();

        if (!nonUnnmoderatedDsps.isEmpty()) {
            return new Defect<>(BlockDefectIds.DspsUnmoderated.HAS_NOT_UNMODERATED,
                    new DspsUnmoderatedDefectParams().withNotUnmoderated(nonUnnmoderatedDsps)
            );
        }

        return null;
    }
}
