package ru.yandex.partner.core.entity.block.type.exdirect;

import NPartner.Page.TPartnerPage;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithExDirectFields;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.CoreConstants.TECHNICAL_RTB_BLOCK_ID;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithExDirectFieldsActivePropHolder.ACTIVE;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithExDirectFieldsExDirectPropHolder.EX_DIRECT;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class BlockWithExDirectFieldsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithExDirectFields>
        implements BlockBkFiller<BlockWithExDirectFields>, CoreModelProvider<BlockWithExDirectFields> {
    private static final CoreModel<BlockWithExDirectFields> CORE_MODEL =
            CoreModel.forClass(BlockWithExDirectFields.class)
                    .property(ModelPropertyDefault.<BlockWithExDirectFields, Boolean>forProperty(EX_DIRECT)
                            .withDefaultValueOnAdd(false))
                    .property(ModelPropertyDefault.<BlockWithExDirectFields, Boolean>forProperty(ACTIVE)
                            .withDefaultValueOnAdd(true))
                    .build();

    private final JooqMapper<BlockWithExDirectFields> jooqMapper;

    public BlockWithExDirectFieldsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        jooqMapper = createBlockMapper();
    }

    private static JooqMapper<BlockWithExDirectFields> createBlockMapper() {
        return JooqMapperBuilder.<BlockWithExDirectFields>builder()
                .map(convertibleProperty(EX_DIRECT, CONTEXT_ON_SITE_RTB.EX_DIRECT,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(convertibleProperty(ACTIVE, CONTEXT_ON_SITE_RTB.ACTIVE,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
    }

    @Override
    public void fillBkData(
            @NotNull BlockWithExDirectFields block,
            @NotNull TPartnerPage.TBlock.Builder bkData,
            @NotNull BlockBkDictContainer container) {
        var builder = bkData.getPageImpOptionsBuilder();

        if (block.getBlockId().equals(TECHNICAL_RTB_BLOCK_ID)
                || block.getExDirect() && !block.getActive()) {
            bkData.setDirectLimit(9);
            builder.addEnable("rtbshadow");
        } else {
            builder.addDisable("rtbshadow");
        }

        if (block.getBlockId().equals(TECHNICAL_RTB_BLOCK_ID)) {
            bkData.setOverrideSizes(true);
        }
    }

    @Override
    public int order() {
        return Order.EX_DIRECT_FIELDS.ordinal();
    }

    @Override
    public JooqMapper<BlockWithExDirectFields> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithExDirectFields> getTypeClass() {
        return BlockWithExDirectFields.class;
    }

    @Override
    public CoreModel<BlockWithExDirectFields> getCoreModel() {
        return CORE_MODEL;
    }
}
