package ru.yandex.partner.core.entity.block.type.formfactorandsiteversion

import NPartner.Page.TPartnerPage.TBlock
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersion
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType
import ru.yandex.partner.core.entity.block.type.siteversionandcontextpage.SiteVersionAvailabilityService
import ru.yandex.partner.libs.bs.ext.adTypeSet
import java.util.*
import java.util.stream.Collectors

@Component
class BlockWithSiteVersionBkFiller @Autowired constructor(
    private val siteVersionAvailabilityService: SiteVersionAvailabilityService
) :
    BlockBkFiller<BlockWithSiteVersion> {

    override fun fillBkData(
        block: BlockWithSiteVersion, bkData: TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        if (block.siteVersion == null) {
            return
        }
        val available: Set<String> = siteVersionAvailabilityService.getAvailableVersionsLiterals(block.javaClass)
        val versionWithImpOption = Arrays.stream(SiteVersionType.values())
            .filter { version: SiteVersionType -> available.contains(version.getLiteral()) }
            .filter { version: SiteVersionType -> version.pageImpOption != null }
            .collect(Collectors.toSet())

        when (block.siteVersion) {
            SiteVersionType.MOBILE_FULLSCREEN.literal -> {
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_MOTION).setValue(false)
            }
            SiteVersionType.MOBILE_REWARDED.literal -> {
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_PERFORMANCE).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_MOTION).setValue(true)
            }
            SiteVersionType.MOBILE_FLOORAD.literal -> {
                bkData.adTypeSet(TBlock.EAdType.TEXT).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA).setValue(true)
                bkData.adTypeSet(TBlock.EAdType.MEDIA_PERFORMANCE).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.VIDEO).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_PERFORMANCE).setValue(false)
                bkData.adTypeSet(TBlock.EAdType.VIDEO_MOTION).setValue(false)
            }
        }

        for (version in versionWithImpOption) {
            if (version.getLiteral() == block.siteVersion) {
                bkData.pageImpOptionsBuilder
                    .addEnable(version.pageImpOption)
            } else {
                bkData.pageImpOptionsBuilder
                    .addDisable(version.pageImpOption)
            }
        }
    }

    override fun getTypeClass(): Class<BlockWithSiteVersion> {
        return BlockWithSiteVersion::class.java
    }

    override fun order(): Int {
        return BlockBkFiller.Order.SITE_VERSION.ordinal
    }
}
