package ru.yandex.partner.core.entity.block.type.formfactorandsiteversion;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersion;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbSiteVersion;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithSiteVersionSiteVersionPropHolder.SITE_VERSION;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithSiteVersionRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithSiteVersion>
        implements CoreModelProvider<BlockWithSiteVersion> {
    public static final CoreModel<BlockWithSiteVersion> MODEL = CoreModel.forClass(BlockWithSiteVersion.class)
            .property(ModelPropertyDefault.<BlockWithSiteVersion, String>forProperty(SITE_VERSION)
                    .withDefaultValueOnAdd(SiteVersionType.DESKTOP.getLiteral()))
            .build();
    private final JooqMapper<BlockWithSiteVersion> mapper;

    @Autowired
    protected BlockWithSiteVersionRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithSiteVersion> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithSiteVersion>builder()
                .map(convertibleProperty(SITE_VERSION, CONTEXT_ON_SITE_RTB.SITE_VERSION,
                        ContextOnSiteRtbSiteVersion::getLiteral, ContextOnSiteRtbSiteVersion::valueOf))
                .build();
    }

    @Override
    public JooqMapper<BlockWithSiteVersion> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithSiteVersion> getTypeClass() {
        return BlockWithSiteVersion.class;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithSiteVersion model) {
        return MODEL.resolveEditableProperties(model);
    }

    @Override
    public CoreModel<BlockWithSiteVersion> getCoreModel() {
        return MODEL;
    }

}
