package ru.yandex.partner.core.entity.block.type.geo;

import java.util.List;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithGeo;
import ru.yandex.partner.core.entity.block.model.Geo;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithGeoGeoPropHolder;
import ru.yandex.partner.core.validation.ModelWithDictEntriesListValidator;

public class BlockWithGeoListValidator extends ModelWithDictEntriesListValidator<BlockWithGeo, Geo> {

    private final GeoValidatorProvider geoValidatorProvider;

    public BlockWithGeoListValidator(GeoValidatorProvider geoValidatorProvider,
                                     Set<Long> existingGeoIds) {
        super(existingGeoIds);
        this.geoValidatorProvider = geoValidatorProvider;
    }

    @Override
    protected void validateModel(ModelItemValidationBuilder<BlockWithGeo> vb) {
        vb.list(getModelPropertyToCheck()).checkEachBy(geoValidatorProvider.geoValidator());
    }

    @Override
    protected ModelProperty<BlockWithGeoGeoPropHolder, List<Geo>> getModelPropertyToCheck() {
        return BlockWithGeo.GEO;
    }

    @Override
    @Nonnull
    protected Function<Geo, Long> idGetter() {
        return Geo::getId;
    }
}
