package ru.yandex.partner.core.entity.block.type.geo;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithGeo;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithGeoUpdateOperationTypeSupport extends AbstractBlockUpdateOperationTypeSupport<BlockWithGeo> {

    private static final Set<ModelProperty<? super BlockWithGeo, ?>> NEED_UPDATE_IN_BK_FIELDS =
            Set.of(BlockWithGeo.GEO);

    public BlockWithGeoUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithGeo> getTypeClass() {
        return BlockWithGeo.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithGeo, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
