package ru.yandex.partner.core.entity.block.type.geo;

import java.util.List;
import java.util.stream.Collectors;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithGeo;
import ru.yandex.partner.core.entity.block.model.Geo;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.geo.GeoBaseRepository;

@Component
public class BlockWithGeoValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithGeo> {

    private final BlockWithGeoValidatorProvider validatorProvider;

    private final DSLContext dslContext;
    private final GeoBaseRepository geoBaseRepository;

    @Autowired
    public BlockWithGeoValidationTypeSupport(BlockWithGeoValidatorProvider validatorProvider,
                                             DSLContext dslContext,
                                             GeoBaseRepository geoBaseRepository) {

        this.validatorProvider = validatorProvider;
        this.dslContext = dslContext;
        this.geoBaseRepository = geoBaseRepository;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithGeo> blocks) {
        if (container.getAvailableGeoIds() == null) {
            container.setAvailableGeoIds(geoBaseRepository.getExistingIds(
                    dslContext,
                    blocks.stream().filter(b -> b.getGeo() != null)
                            .flatMap(block -> block.getGeo().stream().map(Geo::getId))
                            .collect(Collectors.toSet())
                    )
            );
        }
    }

    @Override
    public void fillContainerFullDictionaries(BlockContainer container) {
        container.setAvailableGeoIds(geoBaseRepository.getAllExistingIds(dslContext));
    }

    @Override
    public Class<BlockWithGeo> getTypeClass() {
        return BlockWithGeo.class;
    }

    @Override
    public ValidationResult<List<BlockWithGeo>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithGeo>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkBy(validatorProvider.validator(container.getAvailableGeoIds()))
                .getResult();
    }
}
