package ru.yandex.partner.core.entity.block.type.geo;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.partner.core.entity.block.model.BlockWithGeo;

@Component
public class BlockWithGeoValidatorProvider {

    private final GeoValidatorProvider geoValidatorProvider;

    @Autowired
    public BlockWithGeoValidatorProvider(GeoValidatorProvider geoValidatorProvider) {
        this.geoValidatorProvider = geoValidatorProvider;
    }

    public Validator<List<BlockWithGeo>, Defect> validator(Set<Long> existingGeoIds) {
        return new BlockWithGeoListValidator(geoValidatorProvider, existingGeoIds);
    }

}
