package ru.yandex.partner.core.entity.block.type.geo;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.Geo;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.StrategyDefectParams;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.greaterThan;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;
import static ru.yandex.partner.core.CoreConstants.MAX_CPM;
import static ru.yandex.partner.core.CoreConstants.MIN_CPM;

public class GeoValidator implements Validator<Geo, Defect> {

    @Override
    public ValidationResult<Geo, Defect> apply(Geo geo) {
        ModelItemValidationBuilder<Geo> vb = ModelItemValidationBuilder.of(geo);
        vb.item(Geo.ID).check(notNull()).check(greaterThan(0L), When.notNull());
        var defect = new Defect<>(BlockDefectIds.Strategy.INCORRECT_MINCPM_VALUE,
                new StrategyDefectParams().withMinCpm(MIN_CPM).withMaxCpm(MAX_CPM));
        vb.item(Geo.CPM).check(notNull()).check(inRange(MIN_CPM, CoreConstants.MAX_CPM), defect, When.notNull());
        return vb.getResult();
    }
}
